// $Id: CDropEvent.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDropEvent.hpp"
using Exponent::GUI::Events::CDropEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CDropEvent, CCountedObject);

//	===========================================================================
CDropEvent::CDropEvent(const CPoint &position) : m_droppedFiles(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CDropEvent);
	m_droppedFiles = new TStringCountedPointerArray;
	this->setDropFilePosition(position);
}

//	===========================================================================
CDropEvent::~CDropEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CDropEvent);
	FREE_POINTER(m_droppedFiles);
}

//	===========================================================================
CDropEvent &CDropEvent::operator = (const CDropEvent &event)
{
	// Check we are not the same
	if (this != &event)
	{
		// Store the position
		m_position = event.m_position;

		// Loop throught the events
		for (long i = 0; i < event.m_droppedFiles->getArraySize(); i++)
		{
			// Store the string
			CString *string = event.m_droppedFiles->elementAtIndex(i);

			// Check the string is valid
			if (string)
			{
				// Add it to the array
				m_droppedFiles->addElement(new CString(*string));
			}
		}
	}

	// Return a reference to this
	return *this;
}

//	===========================================================================
void CDropEvent::setDropFilePosition(const CPoint &position) 
{ 
	m_position = position; 
}

//	===========================================================================
TStringCountedPointerArray *CDropEvent::getDroppedFileNames() const 
{ 
	return m_droppedFiles; 
}

//	===========================================================================
const CPoint &CDropEvent::getDropFilePosition() const 
{ 
	return m_position; 
}